function[res,hN]=Empinv(data,p,pAR,pAR1,f,f1,ip,ip1,iq1,cnst,s2,N)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 3.8 (see also Algorithm 3.1)
% File: Empinv.m
%
% Checking empirical invertibility of a mixed (subset) BL model 
%       with a linear AR part. 
% INPUT:
% data   = time series
% p      = maximum AR order
% pAR    = number AR lags; 
% pAR1   = number of mixed lag AR terms
% f      = (pAR * 1)  parameter vector for pure AR part
%                     (Note: input assumes all lags are on RHS)
% f1     = (pAR1 * 1) parameter vector for mixed BL part
% ip     = (pAR * 1)  vector with lags for pure AR part
% ip1    = (pAR1 * 1) vector with lags for Y_{t-ip1}*e_{t-iq1})
% iq1    = (qBL1 * 1) vector with lags for Y_{t-ip1}*e_{t-iq1})
% cnst   = constant
% s2     = residual variance
% N      = number of "after sample" observations
%
% OUTPUT:
% res    = "after sample" residuals 
% hN     = estimate of E[e^{2}_{t}]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
y    = data;
T    = length(data);
qBL1 = pAR1;

% Obtain "within sample" residuals 
e = zeros(p,1);
for it=(p+1):T 
    v1 = 0;
    v2 = 0;
    for j=1:pAR
       v1 = v1+f(j)*y(it-ip(j));  % Linear AR part
    end  
    for j=1:qBL1
       v2 = v2+f1(j)*y(it-ip1(j))*e(it-iq1(j));
    end
  e(it) = y(it)-v1-v2-cnst;
end

% Generate "after sample" observations Y_{T+1},...,Y_{N}
% using past observations of Y(t), past values of e(it), 
% and values of epsilon-tilde(t)
rng('default') % The same random numbers are produced as if you
               % restarted MATLAB
u3     = normrnd(0,1,N,1);

for it=T+1:N    
  e(it) = sqrt(s2)*u3(it);  % series epsilon-tilde_{t}
  v1    = 0;
  v2    = 0;
  for j=1:pAR
      v1 = v1+f(j)*y(it-ip(j));
  end
  for j=1:qBL1
      v2 = v2+f1(j)*y(it-ip1(j))*e(it-iq1(j)); 
  end                                       
  y(it) = e(it)+v1+v2+cnst;                   
end
       
% Obtain "after sample" residuals and hN=sum(e^2)/(it-T).
% For small values of the ratio (ht/it), the model is assumed to be
% invertible
hN = zeros(N,1);
ht = 0;
for it=T+1:N
    v1 = 0;
    v2 = 0;
    for j=1:pAR
        v1 = v1+f(j)*y(it-ip(j));
    end
    for j=1:qBL1
        v2 = v2+f1(j)*y(it-ip1(j))*e(it-iq1(j));
    end                                   
    res(it) = y(it)-v1-v2-cnst; % (Y-tilde)-(fitted "after sample" values)
    ht      = ht+(res(it)-u3(it))*(res(it)-u3(it));
    hN(it)  = ht/(it-N);
end
